/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.jei;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.client.compat.jei.renderer.JunkSlotRenderer;
import com.zurrtum.create.client.compat.jei.renderer.SlotRenderer;
import com.zurrtum.create.client.compat.jei.widget.ChanceTooltip;
import com.zurrtum.create.client.compat.jei.widget.KeepHeldTooltip;
import com.zurrtum.create.client.compat.jei.widget.PotionTooltip;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.fluid.FluidStackIngredient;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3611;
import net.minecraft.class_6885;
import net.minecraft.class_9326;

@Environment(value=EnvType.CLIENT)
public abstract class CreateCategory<T>
implements IRecipeCategory<T> {
    public static final SlotRenderer EMPTY = new SlotRenderer(null, 18, 18);
    public static final SlotRenderer SLOT = new SlotRenderer(AllGuiTextures.JEI_SLOT);
    public static final SlotRenderer CHANCE_SLOT = new SlotRenderer(AllGuiTextures.JEI_CHANCE_SLOT);
    public static final PotionTooltip POTION = new PotionTooltip();
    public static final KeepHeldTooltip KEEP_HELD = new KeepHeldTooltip();

    public static List<class_1799> getStacks(SizedIngredient ingredient) {
        int count = ingredient.getCount();
        return ingredient.getIngredient().field_9019.method_40239().map(entry -> new class_1799(entry, count)).toList();
    }

    public static List<class_1799> getStacks(class_1856 ingredient) {
        return ingredient.field_9019.method_40239().map(class_1799::new).toList();
    }

    public static List<List<class_1799>> condenseIngredients(List<class_1856> ingredients) {
        ArrayList<class_1799> cache = new ArrayList<class_1799>();
        ArrayList<List<class_1799>> result = new ArrayList<List<class_1799>>();
        block0: for (class_1856 ingredient : ingredients) {
            class_6885 entries = ingredient.field_9019;
            if (entries.method_40247() != 1) {
                result.add(CreateCategory.getStacks(ingredient));
                continue;
            }
            class_1792 item = (class_1792)entries.method_40240(0).comp_349();
            for (class_1799 target : cache) {
                if (!target.method_31574(item)) continue;
                target.method_7933(1);
                continue block0;
            }
            class_1799 stack = item.method_7854();
            cache.add(stack);
            result.add(List.of(stack));
        }
        return result;
    }

    public static IRecipeSlotBuilder addFluidSlot(IRecipeLayoutBuilder builder, int x, int y, FluidStack stack) {
        int amount = stack.getAmount();
        IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addOutputSlot(x, y).setFluidRenderer((long)amount, false, 16, 16).add(stack.getFluid(), (long)amount, stack.getComponentChanges());
        if (stack.isOf((class_3611)AllFluids.POTION)) {
            slot.addRichTooltipCallback((IRecipeSlotRichTooltipCallback)POTION);
        }
        return slot;
    }

    public static IRecipeSlotBuilder addFluidSlot(IRecipeLayoutBuilder builder, int x, int y, FluidIngredient fluidIngredient) {
        int amount = fluidIngredient.amount();
        IRecipeSlotBuilder slot = builder.addInputSlot(x, y).setFluidRenderer((long)amount, false, 16, 16);
        class_9326 components = class_9326.field_49588;
        if (fluidIngredient instanceof FluidStackIngredient) {
            FluidStackIngredient stackIngredient = (FluidStackIngredient)fluidIngredient;
            components = stackIngredient.components();
        }
        boolean ignorePotion = true;
        for (class_3611 fluid : fluidIngredient.getMatchingFluids()) {
            slot.add(fluid, (long)amount, components);
            if (!ignorePotion || fluid != AllFluids.POTION) continue;
            ignorePotion = false;
        }
        if (ignorePotion) {
            return slot;
        }
        return slot.addRichTooltipCallback((IRecipeSlotRichTooltipCallback)POTION);
    }

    public static void addChanceSlot(IRecipeLayoutBuilder builder, int x, int y, ProcessingOutput output) {
        IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addOutputSlot(x, y).add(output.create());
        float chance = output.chance();
        if (chance == 1.0f) {
            slot.setBackground((IDrawable)SLOT, -1, -1);
        } else {
            slot.setBackground((IDrawable)CHANCE_SLOT, -1, -1).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)new ChanceTooltip(chance));
        }
    }

    public static IRecipeSlotBuilder addJunkSlot(IRecipeLayoutBuilder builder, int x, int y) {
        return JunkSlotRenderer.addSlot(builder, x, y);
    }

    public int getWidth() {
        return 177;
    }
}

